
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Hank
x1 = m.addVar(name="x1", lb=0)  # hours worked by Peggy
x2 = m.addVar(name="x2", lb=0)  # hours worked by Mary
x3 = m.addVar(name="x3", lb=0, integrality=gp.GRB.INTEGER)  # hours worked by Dale

# Define the objective function
m.setObjective(6*x0**2 + 6*x0*x1 + 9*x0*x2 + 2*x1**2 + 4*x1*x2 + 9*x1*x3 + 5*x3**2 + 7*x0 + 7*x1 + 7*x2, gp.GRB.MAXIMIZE)

# Add constraints
# Individual ratings (not directly constrained but used in combined constraints)
productivity_rating = {'x0': 7.78, 'x1': 4.57, 'x2': 2.91, 'x3': 5.28}
likelihood_to_quit_index = {'x0': 7.7, 'x1': 8.32, 'x2': 6.3, 'x3': 8.37}
dollar_cost_per_hour = {'x0': 1.01, 'x1': 0.91, 'x2': 8.59, 'x3': 4.06}
computer_competence_rating = {'x0': 6.02, 'x1': 6.71, 'x2': 2.0, 'x3': 6.5}
work_quality_rating = {'x0': 3.38, 'x1': 8.21, 'x2': 8.49, 'x3': 6.87}

# Combined productivity rating constraints
m.addConstr(productivity_rating['x2']*x2**2 + productivity_rating['x3']*x3**2 >= 18)
m.addConstr(productivity_rating['x0']*x0 + productivity_rating['x3']*x3 >= 49)
m.addConstr(productivity_rating['x0']*x0**2 + productivity_rating['x2']*x2**2 + productivity_rating['x3']*x3**2 >= 31)
m.addConstr(productivity_rating['x0']*x0 + productivity_rating['x1']*x1 + productivity_rating['x3']*x3 >= 31)
m.addConstr(productivity_rating['x0']*x0 + productivity_rating['x2']*x2 + productivity_rating['x3']*x3 >= 27)

# Combined likelihood to quit index constraints
m.addConstr(likelihood_to_quit_index['x0']*x0**2 + likelihood_to_quit_index['x1']*x1**2 >= 43)
m.addConstr(likelihood_to_quit_index['x1']*x1 + likelihood_to_quit_index['x3']*x3 >= 17)
m.addConstr(likelihood_to_quit_index['x2']*x2 + likelihood_to_quit_index['x3']*x3 >= 29)
m.addConstr(likelihood_to_quit_index['x0']*x0 + likelihood_to_quit_index['x2']*x2 >= 32)
m.addConstr(likelihood_to_quit_index['x1']*x1**2 + likelihood_to_quit_index['x2']*x2**2 >= 25)
m.addConstr(likelihood_to_quit_index['x1']*x1 + likelihood_to_quit_index['x2']*x2 + likelihood_to_quit_index['x3']*x3 >= 41)
m.addConstr(likelihood_to_quit_index['x0']*x0 + likelihood_to_quit_index['x1']*x1 + likelihood_to_quit_index['x3']*x3 >= 41)
m.addConstr(likelihood_to_quit_index['x0']*x0 + likelihood_to_quit_index['x2']*x2 + likelihood_to_quit_index['x3']*x3 >= 41)
m.addConstr(likelihood_to_quit_index['x1']*x1 + likelihood_to_quit_index['x2']*x2 + likelihood_to_quit_index['x3']*x3 >= 33)
m.addConstr(likelihood_to_quit_index['x0']*x0**2 + likelihood_to_quit_index['x1']*x1**2 + likelihood_to_quit_index['x3']*x3**2 >= 33)
m.addConstr(likelihood_to_quit_index['x0']*x0 + likelihood_to_quit_index['x2']*x2 + likelihood_to_quit_index['x3']*x3 >= 33)

# Combined dollar cost per hour constraints
m.addConstr(dollar_cost_per_hour['x0']*x0 + dollar_cost_per_hour['x2']*x2 >= 24)
m.addConstr(dollar_cost_per_hour['x1']*x1**2 + dollar_cost_per_hour['x3']*x3**2 >= 13)
m.addConstr(dollar_cost_per_hour['x0']*x0 + dollar_cost_per_hour['x3']*x3 >= 19)
m.addConstr(dollar_cost_per_hour['x2']*x2 + dollar_cost_per_hour['x3']*x3 >= 18)

# Combined computer competence rating constraints
m.addConstr(computer_competence_rating['x1']*x1**2 + computer_competence_rating['x2']*x2**2 >= 16)
m.addConstr(computer_competence_rating['x0']*x0**2 + computer_competence_rating['x3']*x3**2 >= 29)
m.addConstr(computer_competence_rating['x2']*x2**2 + computer_competence_rating['x3']*x3**2 >= 42)
m.addConstr(computer_competence_rating['x0']*x0 + computer_competence_rating['x2']*x2 >= 32)

# Combined work quality rating constraints
m.addConstr(work_quality_rating['x1']*x1**2 + work_quality_rating['x2']*x2**2 + work_quality_rating['x3']*x3**2 >= 16)
m.addConstr(work_quality_rating['x0']*x0**2 + work_quality_rating['x1']*x1**2 + work_quality_rating['x2']*x2**2 >= 16)
m.addConstr(work_quality_rating['x1']*x1**2 + work_quality_rating['x2']*x2**2 + work_quality_rating['x3']*x3**2 >= 17)
m.addConstr(work_quality_rating['x0']*x0 + work_quality_rating['x1']*x1 + work_quality_rating['x2']*x2 >= 17)

# Upper bound constraints
m.addConstr(productivity_rating['x1']*x1 + productivity_rating['x3']*x3 <= 113)
m.addConstr(productivity_rating['x2']*x2 + productivity_rating['x3']*x3 <= 109)
m.addConstr(productivity_rating['x0']*x0**2 + productivity_rating['x2']*x2**2 <= 174)
m.addConstr(productivity_rating['x1']*x1 + productivity_rating['x2']*x2 <= 117)
m.addConstr(productivity_rating['x0']*x0 + productivity_rating['x3']*x3 <= 139)
m.addConstr(productivity_rating['x1']*x1**2 + productivity_rating['x2']*x2**2 + productivity_rating['x3']*x3**2 <= 132)
m.addConstr(productivity_rating['x0']*x0 + productivity_rating['x1']*x1 + productivity_rating['x3']*x3 <= 195)
m.addConstr(productivity_rating['x0']*x0 + productivity_rating['x1']*x1 + productivity_rating['x2']*x2 + productivity_rating['x3']*x3 <= 195)

# Likelihood to quit index upper bounds
m.addConstr(likelihood_to_quit_index['x1']*x1**2 + likelihood_to_quit_index['x2']*x2**2 <= 94)
m.addConstr(likelihood_to_quit_index['x1']*x1**2 + likelihood_to_quit_index['x3']*x3**2 <= 181)
m.addConstr(likelihood_to_quit_index['x0']*x0 + likelihood_to_quit_index['x1']*x1 <= 197)
m.addConstr(likelihood_to_quit_index['x0']*x0 + likelihood_to_quit_index['x1']*x1 + likelihood_to_quit_index['x2']*x2 + likelihood_to_quit_index['x3']*x3 <= 197)

# Dollar cost per hour upper bounds
m.addConstr(dollar_cost_per_hour['x1']*x1 + dollar_cost_per_hour['x2']*x2 <= 31)
m.addConstr(dollar_cost_per_hour['x0']*x0 + dollar_cost_per_hour['x3']*x3 <= 54)
m.addConstr(dollar_cost_per_hour['x0']*x0 + dollar_cost_per_hour['x1']*x1 + dollar_cost_per_hour['x2']*x2 + dollar_cost_per_hour['x3']*x3 <= 54)

# Computer competence rating upper bounds
m.addConstr(computer_competence_rating['x0']*x0 + computer_competence_rating['x1']*x1 <= 153)
m.addConstr(computer_competence_rating['x1']*x1**2 + computer_competence_rating['x2']*x2**2 <= 159)
m.addConstr(computer_competence_rating['x0']*x0 + computer_competence_rating['x2']*x2 <= 152)
m.addConstr(computer_competence_rating['x0']*x0 + computer_competence_rating['x1']*x1 + computer_competence_rating['x2']*x2 + computer_competence_rating['x3']*x3 <= 152)

# Work quality rating upper bounds
m.addConstr(work_quality_rating['x2']*x2 + work_quality_rating['x3']*x3 <= 45)
m.addConstr(work_quality_rating['x0']*x0 + work_quality_rating['x2']*x2 <= 61)
m.addConstr(work_quality_rating['x1']*x1 + work_quality_rating['x2']*x2 <= 54)
m.addConstr(work_quality_rating['x0']*x0 + work_quality_rating['x1']*x1 <= 96)
m.addConstr(work_quality_rating['x0']*x0**2 + work_quality_rating['x2']*x2**2 + work_quality_rating['x3']*x3**2 <= 110)
m.addConstr(work_quality_rating['x0']*x0 + work_quality_rating['x1']*x1 + work_quality_rating['x2']*x2 + work_quality_rating['x3']*x3 <= 110)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Hank: ", x0.varValue)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Mary: ", x2.varValue)
    print("Hours worked by Dale: ", x3.varValue)
else:
    print("No optimal solution found.")
