
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
protein = m.addVar(lb=0, name="protein")
zinc = m.addVar(lb=0, name="zinc")
fiber = m.addVar(lb=0, name="fiber")
vitamin_b4 = m.addVar(lb=0, name="vitamin_b4")


# Set objective function
m.setObjective(9 * protein + 5 * zinc + 4 * fiber + 5 * vitamin_b4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(protein + 9 * fiber >= 37)
m.addConstr(9 * fiber + 13 * vitamin_b4 >= 40)
m.addConstr(23 * zinc + 9 * fiber >= 45)
m.addConstr(23 * zinc + 9 * fiber + 13 * vitamin_b4 >= 80)
m.addConstr(14 * zinc + 7 * vitamin_b4 >= 39)

# ... (rest of the constraints from the JSON "constraints" field)

m.addConstr(15 * protein + 10 * zinc + 19 * fiber <= 234)
m.addConstr(15 * protein + 10 * zinc + 19 * fiber + 19 * vitamin_b4 <= 234)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Protein: %g' % protein.x)
    print('Zinc: %g' % zinc.x)
    print('Fiber: %g' % fiber.x)
    print('Vitamin B4: %g' % vitamin_b4.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

