
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Mary
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by Laura
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Ringo
    x3 = model.addVar(vtype=gp.GRB.INTEGER, name="x3") # hours worked by John


    # Set objective function
    model.setObjective(8.56 * x0 + 5.65 * x1 + 7.58 * x2 + 7.27 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1.6 * x1 + 3.99 * x3 >= 11)
    model.addConstr(6.26 * x0 + 1.6 * x1 >= 31)
    model.addConstr(1.6 * x1 + 5.57 * x2 >= 26)
    model.addConstr(5.57 * x2 + 3.99 * x3 >= 30)
    model.addConstr(6.26 * x0 + 1.6 * x1 + 5.57 * x2 + 3.99 * x3 >= 30)
    model.addConstr(0.76 * x0 + 4.04 * x2 >= 51)
    model.addConstr(4.04 * x2 + 5.11 * x3 >= 50)
    model.addConstr(0.76 * x0 + 5.92 * x1 >= 26)
    model.addConstr(5.92 * x1 + 4.04 * x2 >= 36)
    model.addConstr(0.76 * x0 + 5.92 * x1 + 4.04 * x2 + 5.11 * x3 >= 36)
    model.addConstr(-5 * x0 + 5 * x3 >= 0)
    model.addConstr(1.6 * x1 + 3.99 * x3 <= 50)
    model.addConstr(6.26 * x0 + 5.57 * x2 <= 95)
    model.addConstr(1.6 * x1 + 5.57 * x2 <= 79)
    model.addConstr(6.26 * x0 + 5.57 * x2 + 3.99 * x3 <= 99)
    model.addConstr(5.92 * x1 + 4.04 * x2 <= 75)
    model.addConstr(5.92 * x1 + 5.11 * x3 <= 174)
    model.addConstr(0.76 * x0 + 4.04 * x2 <= 227)
    model.addConstr(0.76 * x0 + 5.92 * x1 <= 188)
    model.addConstr(4.04 * x2 + 5.11 * x3 <= 67)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
