
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', lb=0)  # hours worked by Mary
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Laura
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Ringo
    x3 = model.addVar(name='x3', lb=0, integrality=0)  # hours worked by John

    # Define the objective function
    model.setObjective(8.56 * x0 + 5.65 * x1 + 7.58 * x2 + 7.27 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6.26 * x0 <= 137)
    model.addConstr(0.76 * x0 <= 235)
    model.addConstr(1.6 * x1 <= 137)
    model.addConstr(5.92 * x1 <= 235)
    model.addConstr(5.57 * x2 <= 137)
    model.addConstr(4.04 * x2 <= 235)
    model.addConstr(3.99 * x3 <= 137)
    model.addConstr(5.11 * x3 <= 235)
    model.addConstr(1.6 * x1 + 3.99 * x3 >= 11)
    model.addConstr(6.26 * x0 + 1.6 * x1 >= 31)
    model.addConstr(1.6 * x1 + 5.57 * x2 >= 26)
    model.addConstr(5.57 * x2 + 3.99 * x3 >= 30)
    model.addConstr(6.26 * x0 + 1.6 * x1 + 5.57 * x2 + 3.99 * x3 >= 30)
    model.addConstr(0.76 * x0 + 4.04 * x2 >= 51)
    model.addConstr(4.04 * x2 + 5.11 * x3 >= 50)
    model.addConstr(0.76 * x0 + 5.92 * x1 >= 26)
    model.addConstr(5.92 * x1 + 4.04 * x2 >= 36)
    model.addConstr(0.76 * x0 + 5.92 * x1 + 4.04 * x2 + 5.11 * x3 >= 36)
    model.addConstr(-5 * x0 + 5 * x3 >= 0)
    model.addConstr(1.6 * x1 + 3.99 * x3 <= 50)
    model.addConstr(6.26 * x0 + 5.57 * x2 <= 95)
    model.addConstr(1.6 * x1 + 5.57 * x2 <= 79)
    model.addConstr(6.26 * x0 + 5.57 * x2 + 3.99 * x3 <= 99)
    model.addConstr(5.92 * x1 + 4.04 * x2 <= 75)
    model.addConstr(5.92 * x1 + 5.11 * x3 <= 174)
    model.addConstr(0.76 * x0 + 4.04 * x2 <= 227)
    model.addConstr(0.76 * x0 + 5.92 * x1 <= 188)
    model.addConstr(4.04 * x2 + 5.11 * x3 <= 67)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Mary: ', x0.varValue)
        print('Hours worked by Laura: ', x1.varValue)
        print('Hours worked by Ringo: ', x2.varValue)
        print('Hours worked by John: ', x3.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
