
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
    vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")


    # Set objective function
    m.setObjective(8 * vitamin_e + 1 * vitamin_d + 8 * vitamin_b6, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1.79 * vitamin_e + 1.9 * vitamin_d + 0.03 * vitamin_b6 <= 127, "immune_support_index_total")
    m.addConstr(1.9 * vitamin_d + 0.03 * vitamin_b6 <= 65, "immune_support_d_b6")
    m.addConstr(1.79 * vitamin_e + 1.9 * vitamin_d <= 77, "immune_support_e_d")
    m.addConstr(1.79 * vitamin_e + 1.9 * vitamin_d + 0.03 * vitamin_b6 <= 48, "immune_support_total_limit")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_e: %g' % vitamin_e.x)
        print('vitamin_d: %g' % vitamin_d.x)
        print('vitamin_b6: %g' % vitamin_b6.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status %d" % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
