
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, ub=None)  # milligrams of vitamin E
    x2 = model.addVar(name="x2", lb=0, ub=None)  # milligrams of vitamin D
    x3 = model.addVar(name="x3", lb=0, ub=None)  # milligrams of vitamin B6

    # Define the objective function
    model.setObjective(8*x1 + x2 + 8*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1.9*x2 + 0.03*x3 <= 65)
    model.addConstr(1.79*x1 + 1.9*x2 <= 77)
    model.addConstr(1.79*x1 + 1.9*x2 + 0.03*x3 <= 48)

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x1.varValue}")
        print(f"Milligrams of vitamin D: {x2.varValue}")
        print(f"Milligrams of vitamin B6: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
