
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B2
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin C
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B7


    # Set objective function
    m.setObjective(9.96 * x0 + 9.49 * x1 + 2.05 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4 * x0 + 8 * x1 >= 16, "c0")
    m.addConstr(4 * x0 + 14 * x2 >= 28, "c1")
    m.addConstr(4 * x0 + 8 * x1 + 14 * x2 >= 28, "c2")
    m.addConstr(10 * x1 + 3 * x2 >= 20, "c3")
    m.addConstr(9 * x0 + 3 * x2 >= 31, "c4")
    m.addConstr(9 * x0 + 10 * x1 + 3 * x2 >= 31, "c5")
    m.addConstr(1 * x0 + 4 * x2 >= 41, "c6")
    m.addConstr(1 * x0 + 8 * x1 >= 45, "c7")
    m.addConstr(1 * x0 + 8 * x1 + 4 * x2 >= 24, "c8")
    m.addConstr(7 * x0 + 2 * x1 >= 16, "c9")
    m.addConstr(7 * x0 + 14 * x2 >= 16, "c10")
    m.addConstr(7 * x0 + 2 * x1 + 14 * x2 >= 16, "c11")
    m.addConstr(-6 * x0 + 1 * x1 >= 0, "c12")
    m.addConstr(7 * x1 - 10 * x2 >= 0, "c13")
    m.addConstr(1 * x0 + 4 * x2 <= 117, "c14")
    m.addConstr(1 * x0 + 8 * x1 <= 45, "c15")
    m.addConstr(7 * x0 + 14 * x2 <= 25, "c16")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
