
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="milligrams of vitamin B2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x1 = model.addVar(name="milligrams of vitamin C", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name="milligrams of vitamin B7", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Set the objective function
model.setObjective(9.96 * x0 + 9.49 * x1 + 2.05 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * x0 <= 92)
model.addConstr(9 * x0 <= 134)
model.addConstr(1 * x0 <= 135)
model.addConstr(7 * x0 <= 63)

model.addConstr(8 * x1 <= 92)
model.addConstr(10 * x1 <= 134)
model.addConstr(8 * x1 <= 135)
model.addConstr(2 * x1 <= 63)

model.addConstr(14 * x2 <= 92)
model.addConstr(3 * x2 <= 134)
model.addConstr(4 * x2 <= 135)
model.addConstr(14 * x2 <= 63)

model.addConstr(4 * x0 + 8 * x1 >= 16)
model.addConstr(4 * x0 + 14 * x2 >= 28)
model.addConstr(4 * x0 + 8 * x1 + 14 * x2 >= 28)

model.addConstr(10 * x1 + 3 * x2 >= 20)
model.addConstr(9 * x0 + 3 * x2 >= 31)
model.addConstr(9 * x0 + 10 * x1 + 3 * x2 >= 31)

model.addConstr(1 * x0 + 4 * x2 >= 41)
model.addConstr(1 * x0 + 8 * x1 >= 45)
model.addConstr(1 * x0 + 8 * x1 + 4 * x2 >= 24)

model.addConstr(7 * x0 + 2 * x1 >= 16)
model.addConstr(7 * x0 + 14 * x2 >= 16)
model.addConstr(7 * x0 + 2 * x1 + 14 * x2 >= 16)

model.addConstr(-6 * x0 + 1 * x1 >= 0)
model.addConstr(7 * x1 - 10 * x2 >= 0)

model.addConstr(1 * x0 + 4 * x2 <= 117)
model.addConstr(1 * x0 + 8 * x1 <= 45)
model.addConstr(7 * x0 + 14 * x2 <= 25)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B2: ", x0.varValue)
    print("Milligrams of vitamin C: ", x1.varValue)
    print("Milligrams of vitamin B7: ", x2.varValue)
    print("Objective function value: ", model.objVal)
else:
    print("No optimal solution found.")
