
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("Resilience Optimization")

    # Create variables
    bean_stalks = m.addVar(vtype=gp.GRB.INTEGER, name="bean_stalks")
    orange_trees = m.addVar(vtype=gp.GRB.INTEGER, name="orange_trees")
    pansies = m.addVar(vtype=gp.GRB.INTEGER, name="pansies")
    apple_trees = m.addVar(vtype=gp.GRB.INTEGER, name="apple_trees")

    # Set objective function
    m.setObjective(7.64 * bean_stalks + 4.45 * orange_trees + 6.11 * pansies + 7.77 * apple_trees, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14.59 * bean_stalks + 17.7 * pansies >= 21, "c1")
    m.addConstr(14.59 * bean_stalks + 8.06 * apple_trees >= 51, "c2")
    m.addConstr(14.59 * bean_stalks + 19.86 * orange_trees >= 43, "c3")
    m.addConstr(19.86 * orange_trees + 8.06 * apple_trees >= 49, "c4")
    m.addConstr(14.59 * bean_stalks + 19.86 * orange_trees + 17.7 * pansies >= 50, "c5")
    m.addConstr(19.86 * orange_trees + 17.7 * pansies + 8.06 * apple_trees >= 50, "c6")
    m.addConstr(14.59 * bean_stalks + 19.86 * orange_trees + 17.7 * pansies >= 25, "c7")
    m.addConstr(19.86 * orange_trees + 17.7 * pansies + 8.06 * apple_trees >= 25, "c8")
    m.addConstr(14.59 * bean_stalks + 19.86 * orange_trees + 17.7 * pansies + 8.06 * apple_trees >= 25, "c9")
    m.addConstr(-3 * bean_stalks + 1 * pansies >= 0, "c10")
    m.addConstr(-7 * orange_trees + 2 * pansies >= 0, "c11")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
