
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='bean_stalks', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='orange_trees', vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name='pansies', vtype=gurobi.GRB.INTEGER)
x4 = model.addVar(name='apple_trees', vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(7.64*x1 + 4.45*x2 + 6.11*x3 + 7.77*x4, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(14.59*x1 + 17.7*x3 >= 21)
model.addConstr(14.59*x1 + 8.06*x4 >= 51)
model.addConstr(14.59*x1 + 19.86*x2 >= 43)
model.addConstr(19.86*x2 + 8.06*x4 >= 49)
model.addConstr(14.59*x1 + 19.86*x2 + 17.7*x3 >= 50)
model.addConstr(19.86*x2 + 17.7*x3 + 8.06*x4 >= 50)
model.addConstr(14.59*x1 + 19.86*x2 + 17.7*x3 >= 25)
model.addConstr(19.86*x2 + 17.7*x3 + 8.06*x4 >= 25)
model.addConstr(14.59*x1 + 19.86*x2 + 17.7*x3 + 8.06*x4 >= 25)
model.addConstr(-3*x1 + x3 >= 0)
model.addConstr(-7*x2 + 2*x3 >= 0)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('bean stalks: ', x1.varValue)
    print('orange trees: ', x2.varValue)
    print('pansies: ', x3.varValue)
    print('apple trees: ', x4.varValue)
else:
    print('The model is infeasible')
