
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
steaks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steaks")
pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pasta")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")


# Set objective function
m.setObjective(1*steaks + 3*pasta + 5*hot_dogs + 3*cheeseburgers, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*pasta + 15*hot_dogs >= 97)
m.addConstr(1*steaks + 4*pasta >= 93)
m.addConstr(1*steaks + 4*pasta + 4*cheeseburgers >= 112)
m.addConstr(1*steaks + 15*hot_dogs + 4*cheeseburgers >= 112)
m.addConstr(4*pasta + 15*hot_dogs + 4*cheeseburgers >= 112)
m.addConstr(1*steaks + 4*pasta + 15*hot_dogs >= 112)
m.addConstr(1*steaks + 4*pasta + 4*cheeseburgers >= 136)
m.addConstr(1*steaks + 15*hot_dogs + 4*cheeseburgers >= 136)
m.addConstr(4*pasta + 15*hot_dogs + 4*cheeseburgers >= 136)
m.addConstr(1*steaks + 4*pasta + 15*hot_dogs >= 136)
m.addConstr(1*steaks + 4*pasta + 4*cheeseburgers >= 127)
m.addConstr(1*steaks + 15*hot_dogs + 4*cheeseburgers >= 127)
m.addConstr(4*pasta + 15*hot_dogs + 4*cheeseburgers >= 127)
m.addConstr(1*steaks + 4*pasta + 15*hot_dogs >= 127)
m.addConstr(1*steaks + 4*pasta + 4*cheeseburgers >= 135)
m.addConstr(1*steaks + 15*hot_dogs + 4*cheeseburgers >= 135)
m.addConstr(4*pasta + 15*hot_dogs + 4*cheeseburgers >= 135)
m.addConstr(1*steaks + 4*pasta + 15*hot_dogs >= 135)
m.addConstr(1*steaks + 4*pasta + 15*hot_dogs + 4*cheeseburgers >= 135)
m.addConstr(18*pasta + 34*hot_dogs >= 112)
m.addConstr(3*steaks + 34*hot_dogs >= 107)
m.addConstr(3*steaks + 18*pasta >= 75)
m.addConstr(3*steaks + 18*pasta + 22*cheeseburgers >= 103)
m.addConstr(3*steaks + 18*pasta + 34*hot_dogs >= 103)
m.addConstr(3*steaks + 34*hot_dogs + 22*cheeseburgers >= 103)
m.addConstr(3*steaks + 18*pasta + 22*cheeseburgers >= 113)
m.addConstr(3*steaks + 18*pasta + 34*hot_dogs >= 113)
m.addConstr(3*steaks + 34*hot_dogs + 22*cheeseburgers >= 113)
m.addConstr(3*steaks + 18*pasta + 22*cheeseburgers >= 90)
m.addConstr(3*steaks + 18*pasta + 34*hot_dogs >= 90)
m.addConstr(3*steaks + 34*hot_dogs + 22*cheeseburgers >= 90)
m.addConstr(3*steaks + 18*pasta + 34*hot_dogs + 22*cheeseburgers >= 90)
m.addConstr(-8*steaks + 1*cheeseburgers >= 0)
m.addConstr(-8*hot_dogs + 5*cheeseburgers >= 0)
m.addConstr(4*pasta + 15*hot_dogs <= 510)
m.addConstr(1*steaks + 4*pasta <= 369)
m.addConstr(34*hot_dogs + 22*cheeseburgers <= 249)
m.addConstr(3*steaks + 34*hot_dogs <= 417)
m.addConstr(18*pasta + 22*cheeseburgers <= 323)

# Add total tastiness and cost constraints from the resource dictionary
m.addConstr(1*steaks + 4*pasta + 15*hot_dogs + 4*cheeseburgers <= 567)
m.addConstr(3*steaks + 18*pasta + 34*hot_dogs + 22*cheeseburgers <= 560)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('steaks:', steaks.x)
    print('pasta:', pasta.x)
    print('hot_dogs:', hot_dogs.x)
    print('cheeseburgers:', cheeseburgers.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

