
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by Mary (integer)
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by Jean (continuous)


    # Set objective function
    model.setObjective(7.28*x0**2 + 3.0*x0*x1 + 3.69*x1**2 + 8.12*x0 + 8.29*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3.15*x0 + 3.19*x1 >= 5, "c0") # Total combined organization score minimum
    model.addConstr(2.73*x0 + 1.4*x1 >= 18, "c1") # Total combined paperwork competence rating minimum
    model.addConstr(-x0 + 7*x1 >= 0, "c2") # Constraint on Mary and Jean's hours
    model.addConstr(3.15*x0 + 3.19*x1 <= 21, "c3") # Total combined organization score maximum
    model.addConstr(2.73*x0 + 1.4*x1 <= 36, "c4") # Total combined paperwork competence rating maximum


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Mary (x0): {x0.x}")
        print(f"Hours worked by Jean (x1): {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")
