
import gurobi

def optimization_problem():
    model = gurobi.Model()
    
    # Variables
    x1 = model.addVar(name="hours_worked_by_Mary", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hours_worked_by_Jean", vtype=gurobi.GRB.CONTINUOUS)
    
    # Objective function
    model.setObjective(7.28*x1**2 + 3.0*x1*x2 + 3.69*x2**2 + 8.12*x1 + 8.29*x2, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(3.15*x1 == 3.15, name="Mary_organization_score")
    model.addConstr(2.73*x1 == 2.73, name="Mary_paperwork_competence_rating")
    model.addConstr(3.19*x2 == 3.19, name="Jean_organization_score")
    model.addConstr(1.4*x2 == 1.4, name="Jean_paperwork_competence_rating")
    model.addConstr(3.15*x1 + 3.19*x2 >= 5, name="total_organization_score_min")
    model.addConstr(2.73*x1 + 1.4*x2 >= 18, name="total_paperwork_competence_rating_min")
    model.addConstr(-x1 + 7*x2 >= 0, name="hours_worked_constraint")
    model.addConstr(3.15*x1 + 3.19*x2 <= 21, name="total_organization_score_max")
    model.addConstr(2.73*x1 + 1.4*x2 <= 36, name="total_paperwork_competence_rating_max")
    
    # Solve the model
    model.optimize()
    
    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Mary: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible")
    else:
        print("The model has a non-optimal status")

optimization_problem()
