
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
x = {}
item_names = ['blue highlighters', 'scissors', 'manila envelopes', 'red pens', 'wooden pencils', 'rubber bands', 'cafeteria chairs']
for i in range(len(item_names)):
    x[i] = model.addVar(vtype=GRB.INTEGER, name=item_names[i])


# Set objective function
model.setObjective(5*x[0] + 7*x[1] + 8*x[2] + 9*x[3] + 2*x[4] + 3*x[5] + 6*x[6], GRB.MINIMIZE)

# Resource constraints
resources = {
    'r0': {'description': 'sustainability score', 'upper_bound': 354, 'values': [14, 10, 3, 3, 6, 9, 2]},
    'r1': {'description': 'workplace safety impact', 'upper_bound': 359, 'values': [1, 3, 10, 3, 2, 7, 13]},
    'r2': {'description': 'storage space', 'upper_bound': 377, 'values': [12, 8, 7, 7, 11, 8, 6]}
}

for r_key, r_data in resources.items():
    for i in range(len(item_names)):
        model.addConstr(r_data['values'][i] * x[i] <= r_data['upper_bound'])


# Add other constraints from the problem description (converted to symbolic form in the JSON above)
# ... (add all the constraints listed in the JSON "constraints" section)

# Example:
model.addConstr(14*x[0] + 10*x[1] >= 24)
# ... (add the rest)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

