
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x = m.addVars(7, name="x", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5*x[0] + 7*x[1] + 8*x[2] + 9*x[3] + 2*x[4] + 3*x[5] + 6*x[6], gp.GRB.MINIMIZE)

# Define the resources/attributes
resources = {
    'r0': {'description': 'sustainability score', 'upper_bound': 354, 'x0': 14, 'x1': 10, 'x2': 3, 'x3': 3, 'x4': 6, 'x5': 9, 'x6': 2},
    'r1': {'description': 'workplace safety impact', 'upper_bound': 359, 'x0': 1, 'x1': 3, 'x2': 10, 'x3': 3, 'x4': 2, 'x5': 7, 'x6': 13},
    'r2': {'description': 'storage space', 'upper_bound': 377, 'x0': 12, 'x1': 8, 'x2': 7, 'x3': 7, 'x4': 11, 'x5': 8, 'x6': 6}
}

# Add constraints
# Sustainability score constraints
m.addConstr(14*x[0] + 10*x[1] >= 24)
m.addConstr(10*x[1] + 3*x[2] >= 18)
m.addConstr(10*x[1] + 3*x[3] >= 30)
m.addConstr(3*x[3] + 6*x[4] >= 34)
m.addConstr(3*x[2] + 2*x[6] >= 47)
m.addConstr(9*x[5] + 2*x[6] >= 30)
m.addConstr(14*x[0] + 10*x[1] + 3*x[2] >= 28)
m.addConstr(6*x[4] + 9*x[5] + 2*x[6] >= 28)
m.addConstr(10*x[1] + 3*x[3] + 2*x[6] >= 28)
m.addConstr(3*x[3] + 6*x[4] + 9*x[5] >= 28)
m.addConstr(14*x[0] + 10*x[1] + 3*x[2] >= 35)
m.addConstr(6*x[4] + 9*x[5] + 2*x[6] >= 35)
m.addConstr(10*x[1] + 3*x[3] + 2*x[6] >= 35)
m.addConstr(3*x[3] + 6*x[4] + 9*x[5] >= 35)

# Workplace safety impact constraints
m.addConstr(x[0] + 7*x[5] >= 22)
m.addConstr(3*x[3] + 7*x[5] >= 18)
m.addConstr(x[0] + 13*x[6] >= 45)
m.addConstr(2*x[4] + 7*x[5] >= 27)
m.addConstr(2*x[4] + 13*x[6] >= 30)
m.addConstr(3*x[1] + 13*x[6] >= 25)
m.addConstr(3*x[3] + 2*x[4] >= 42)
m.addConstr(3*x[1] + 3*x[3] >= 50)
m.addConstr(10*x[2] + 2*x[4] >= 46)
m.addConstr(7*x[5] + 13*x[6] >= 38)
m.addConstr(x[0] + 3*x[3] >= 41)
m.addConstr(3*x[3] + 13*x[6] >= 37)
m.addConstr(x[0] + 3*x[1] >= 44)

# Storage space constraints
m.addConstr(12*x[0] + 8*x[1] + 7*x[2] + 7*x[3] + 11*x[4] + 8*x[5] + 6*x[6] <= 377)
m.addConstr(8*x[1] + 7*x[2] + 7*x[3] + 11*x[4] + 8*x[5] + 6*x[6] <= 377)
m.addConstr(12*x[0] + 8*x[1] <= 303)
m.addConstr(8*x[5] + 6*x[6] <= 108)
m.addConstr(7*x[2] + 8*x[5] <= 344)
m.addConstr(8*x[1] + 7*x[2] <= 249)
m.addConstr(12*x[0] + 11*x[4] <= 79)
m.addConstr(7*x[2] + 7*x[3] <= 89)
m.addConstr(7*x[2] + 11*x[4] <= 80)
m.addConstr(7*x[3] + 11*x[4] <= 121)
m.addConstr(11*x[4] + 8*x[5] <= 149)
m.addConstr(12*x[0] + 8*x[5] <= 299)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    for i in range(7):
        print(f"x[{i}] = {x[i].varValue}")
else:
    print("No solution found")
