
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of magnesium")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="grams of fiber")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin E")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of potassium")
    x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin B1")


    # Set objective function
    m.setObjective(4.09*x0 + 2.57*x1 + 2.4*x2 + 9.41*x3 + 2.58*x4, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(12*x0 + 18*x1 + 15*x2 + 9*x3 + 3*x4 <= 174, "c0")
    m.addConstr(18*x1 + 3*x4 >= 19, "c1")
    m.addConstr(12*x0 + 3*x4 >= 27, "c2")
    m.addConstr(18*x1 + 15*x2 >= 18, "c3")
    m.addConstr(15*x2 + 3*x4 >= 21, "c4")
    m.addConstr(18*x1 + 9*x3 >= 18, "c5")
    m.addConstr(12*x0 + 18*x1 + 15*x2 + 9*x3 + 3*x4 >= 18, "c6")
    m.addConstr(-x0 + 7*x3 >= 0, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
