
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milligrams_of_magnesium", lb=0)
x2 = m.addVar(name="grams_of_fiber", lb=0)
x3 = m.addVar(name="milligrams_of_vitamin_E", lb=0)
x4 = m.addVar(name="milligrams_of_potassium", lb=0)
x5 = m.addVar(name="milligrams_of_vitamin_B1", lb=0)

# Objective function
m.setObjective(4.09*x1 + 2.57*x2 + 2.4*x3 + 9.41*x4 + 2.58*x5, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(12*x1 <= 174, name="energy_stability_magnesium")
m.addConstr(18*x2 <= 174, name="energy_stability_fiber")
m.addConstr(15*x3 <= 174, name="energy_stability_vitamin_E")
m.addConstr(9*x4 <= 174, name="energy_stability_potassium")
m.addConstr(3*x5 <= 174, name="energy_stability_vitamin_B1")
m.addConstr(18*x2 + 3*x5 >= 19, name="combined_energy_fiber_B1")
m.addConstr(12*x1 + 3*x5 >= 27, name="combined_energy_magnesium_B1")
m.addConstr(18*x2 + 15*x3 >= 18, name="combined_energy_fiber_E")
m.addConstr(15*x3 + 3*x5 >= 21, name="combined_energy_E_B1")
m.addConstr(18*x2 + 9*x4 >= 18, name="combined_energy_fiber_potassium")
m.addConstr(12*x1 + 18*x2 + 15*x3 + 9*x4 + 3*x5 >= 18, name="total_combined_energy")
m.addConstr(-x1 + 7*x4 >= 0, name="magnesium_potassium_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of magnesium: {x1.varValue}")
    print(f"Grams of fiber: {x2.varValue}")
    print(f"Milligrams of vitamin E: {x3.varValue}")
    print(f"Milligrams of potassium: {x4.varValue}")
    print(f"Milligrams of vitamin B1: {x5.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
