
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("military_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry_companies")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="air_defense_batteries")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="military_intelligence_companies")


    # Set objective function
    m.setObjective(6*x0 + 6*x1 + 2*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(28*x0 + 8*x1 + 22*x2 >= 31, "logistical_capacity_min")
    m.addConstr(24*x0 + 11*x1 + 9*x2 >= 88, "fuel_demand_min")
    m.addConstr(8*x1 + 22*x2 <= 105, "logistical_capacity_x1_x2_max")
    m.addConstr(28*x0 + 22*x2 <= 123, "logistical_capacity_x0_x2_max")
    m.addConstr(28*x0 + 8*x1 <= 126, "logistical_capacity_x0_x1_max")
    m.addConstr(28*x0 + 8*x1 + 22*x2 <= 126, "logistical_capacity_max")
    m.addConstr(24*x0 + 9*x2 <= 252, "fuel_demand_x0_x2_max")
    m.addConstr(11*x1 + 9*x2 <= 212, "fuel_demand_x1_x2_max")
    m.addConstr(24*x0 + 11*x1 + 9*x2 <= 212, "fuel_demand_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0 (light infantry companies): %g' % x0.x)
        print('x1 (air defense batteries): %g' % x1.x)
        print('x2 (military intelligence companies): %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
