
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='light_infantry_companies', vtype='I')
    x1 = model.addVar(name='air_defense_batteries', vtype='I')
    x2 = model.addVar(name='military_intelligence_companies', vtype='I')

    # Define the objective function
    model.setObjective(6 * x0 + 6 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(28 * x0 + 8 * x1 + 22 * x2 >= 31)
    model.addConstr(24 * x0 + 11 * x1 + 9 * x2 >= 88)
    model.addConstr(8 * x1 + 22 * x2 <= 105)
    model.addConstr(28 * x0 + 22 * x2 <= 123)
    model.addConstr(28 * x0 + 8 * x1 <= 126)
    model.addConstr(28 * x0 + 8 * x1 + 22 * x2 <= 126)
    model.addConstr(24 * x0 + 9 * x2 <= 252)
    model.addConstr(11 * x1 + 9 * x2 <= 212)
    model.addConstr(24 * x0 + 11 * x1 + 9 * x2 <= 212)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Light infantry companies: {x0.varValue}')
        print(f'Air defense batteries: {x1.varValue}')
        print(f'Military intelligence companies: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
