
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    ringo = m.addVar(lb=0, name="ringo")
    paul = m.addVar(lb=0, name="paul")
    jean = m.addVar(lb=0, name="jean")
    george = m.addVar(lb=0, name="george")


    # Set objective function
    m.setObjective(6.22 * ringo + 7.73 * paul + 5.82 * jean + 2.73 * george, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1 * ringo + 12 * george >= 98)
    m.addConstr(15 * paul + 12 * george >= 73)
    m.addConstr(1 * ringo + 15 * paul >= 77)
    m.addConstr(1 * ringo + 15 * paul + 12 * george >= 90)
    m.addConstr(1 * ringo + 15 * paul + 16 * jean + 12 * george >= 90)
    m.addConstr(1 * jean + 15 * george >= 44)
    m.addConstr(4 * ringo + 1 * jean >= 47)
    m.addConstr(3 * paul + 1 * jean >= 68)
    m.addConstr(3 * paul + 15 * george >= 46)
    m.addConstr(4 * ringo + 3 * paul >= 68)
    m.addConstr(4 * ringo + 3 * paul + 1 * jean + 15 * george >= 68)
    m.addConstr(12 * jean + 12 * george >= 43)
    m.addConstr(14 * ringo + 9 * paul >= 48)
    m.addConstr(14 * ringo + 12 * george >= 20)
    m.addConstr(14 * ringo + 9 * paul + 12 * jean >= 48)
    m.addConstr(14 * ringo + 12 * jean + 12 * george >= 48)
    m.addConstr(14 * ringo + 9 * paul + 12 * george >= 48)
    m.addConstr(14 * ringo + 9 * paul + 12 * jean >= 47)
    m.addConstr(14 * ringo + 12 * jean + 12 * george >= 47)
    m.addConstr(14 * ringo + 9 * paul + 12 * george >= 47)
    m.addConstr(14 * ringo + 9 * paul + 12 * jean >= 44)
    m.addConstr(14 * ringo + 12 * jean + 12 * george >= 44)
    m.addConstr(14 * ringo + 9 * paul + 12 * george >= 44)
    m.addConstr(14 * ringo + 9 * paul + 12 * jean + 12 * george >= 44)
    m.addConstr(9 * jean + 8 * george >= 20)
    m.addConstr(2 * ringo + 13 * paul >= 33)
    m.addConstr(2 * ringo + 8 * george >= 53)
    m.addConstr(2 * ringo + 9 * jean >= 21)
    m.addConstr(13 * paul + 9 * jean >= 54)
    m.addConstr(2 * ringo + 13 * paul + 8 * george >= 43)
    m.addConstr(2 * ringo + 13 * paul + 9 * jean + 8 * george >= 43)
    m.addConstr(2 * jean + 16 * george >= 49)
    m.addConstr(14 * paul + 2 * jean >= 26)
    m.addConstr(14 * paul + 16 * george >= 37)
    m.addConstr(3 * ringo + 16 * george >= 28)
    m.addConstr(3 * ringo + 14 * paul + 2 * jean + 16 * george >= 28)
    m.addConstr(8 * paul - 6 * george >= 0)
    m.addConstr(8 * jean - 4 * george >= 0)
    m.addConstr(15 * paul + 16 * jean <= 159)
    m.addConstr(4 * ringo + 1 * jean <= 150)
    m.addConstr(1 * jean + 15 * george <= 160)
    m.addConstr(3 * paul + 1 * jean <= 299)
    m.addConstr(4 * ringo + 3 * paul <= 286)
    m.addConstr(3 * paul + 15 * george <= 161)
    m.addConstr(4 * ringo + 3 * paul + 15 * george <= 221)
    m.addConstr(9 * paul + 12 * jean <= 55)
    m.addConstr(14 * ringo + 12 * george <= 110)
    m.addConstr(14 * ringo + 9 * paul <= 63)
    m.addConstr(2 * ringo + 13 * paul <= 72)
    m.addConstr(13 * paul + 8 * george <= 62)
    m.addConstr(2 * ringo + 9 * jean <= 235)
    m.addConstr(2 * ringo + 9 * jean + 8 * george <= 226)
    m.addConstr(2 * ringo + 13 * paul + 8 * george <= 85)
    m.addConstr(2 * ringo + 13 * paul + 9 * jean <= 125)
    m.addConstr(2 * jean + 16 * george <= 206)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
