
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_Ringo")
x1 = m.addVar(lb=0, name="hours_worked_by_Paul")
x2 = m.addVar(lb=0, name="hours_worked_by_Jean")
x3 = m.addVar(lb=0, name="hours_worked_by_George")

# Objective function
m.setObjective(6.22*x0 + 7.73*x1 + 5.82*x2 + 2.73*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(x0 >= 0)
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)
m.addConstr(x0 >= 1)
m.addConstr(4*x0 >= 4)
m.addConstr(14*x0 >= 14)
m.addConstr(2*x0 >= 2)
m.addConstr(3*x0 >= 3)
m.addConstr(15*x1 >= 15)
m.addConstr(3*x1 >= 3)
m.addConstr(9*x1 >= 9)
m.addConstr(13*x1 >= 13)
m.addConstr(14*x1 >= 14)
m.addConstr(16*x2 >= 16)
m.addConstr(x2 >= 1)
m.addConstr(12*x2 >= 12)
m.addConstr(9*x2 >= 9)
m.addConstr(2*x2 >= 2)
m.addConstr(12*x3 >= 12)
m.addConstr(15*x3 >= 15)
m.addConstr(12*x3 >= 12)
m.addConstr(8*x3 >= 8)
m.addConstr(16*x3 >= 16)
m.addConstr(x0 + 12*x3 >= 98)
m.addConstr(15*x1 + 12*x3 >= 73)
m.addConstr(x0 + 15*x1 >= 77)
m.addConstr(x0 + 15*x1 + 12*x3 >= 90)
m.addConstr(x0 + 15*x1 + 16*x2 + 12*x3 >= 90)
m.addConstr(x2 + 15*x3 >= 44)
m.addConstr(4*x0 + x2 >= 47)
m.addConstr(3*x1 + x2 >= 68)
m.addConstr(3*x1 + 15*x3 >= 46)
m.addConstr(4*x0 + 3*x1 >= 68)
m.addConstr(4*x0 + 3*x1 + x2 + 15*x3 >= 68)
m.addConstr(12*x2 + 12*x3 >= 43)
m.addConstr(14*x0 + 9*x1 >= 48)
m.addConstr(14*x0 + 12*x3 >= 20)
m.addConstr(14*x0 + 9*x1 + 12*x2 >= 48)
m.addConstr(14*x0 + 12*x2 + 12*x3 >= 48)
m.addConstr(14*x0 + 9*x1 + 12*x3 >= 48)
m.addConstr(14*x0 + 9*x1 + 12*x2 >= 47)
m.addConstr(14*x0 + 12*x2 + 12*x3 >= 47)
m.addConstr(14*x0 + 9*x1 + 12*x3 >= 47)
m.addConstr(14*x0 + 9*x1 + 12*x2 >= 44)
m.addConstr(14*x0 + 12*x2 + 12*x3 >= 44)
m.addConstr(14*x0 + 9*x1 + 12*x3 >= 44)
m.addConstr(14*x0 + 9*x1 + 12*x2 + 12*x3 >= 44)
m.addConstr(9*x2 + 8*x3 >= 20)
m.addConstr(2*x0 + 13*x1 >= 33)
m.addConstr(2*x0 + 8*x3 >= 53)
m.addConstr(2*x0 + 9*x2 >= 21)
m.addConstr(13*x1 + 9*x2 >= 54)
m.addConstr(2*x0 + 13*x1 + 8*x3 >= 43)
m.addConstr(2*x0 + 13*x1 + 9*x2 + 8*x3 >= 43)
m.addConstr(2*x2 + 16*x3 >= 49)
m.addConstr(14*x1 + 2*x2 >= 26)
m.addConstr(14*x1 + 16*x3 >= 37)
m.addConstr(3*x0 + 16*x3 >= 28)
m.addConstr(3*x0 + 14*x1 + 2*x2 + 16*x3 >= 28)
m.addConstr(8*x1 - 6*x3 >= 0)
m.addConstr(8*x2 - 4*x3 >= 0)
m.addConstr(15*x1 + 16*x2 <= 159)
m.addConstr(4*x0 + x2 <= 150)
m.addConstr(x2 + 15*x3 <= 160)
m.addConstr(3*x1 + x2 <= 299)
m.addConstr(4*x0 + 3*x1 <= 286)
m.addConstr(3*x1 + 15*x3 <= 161)
m.addConstr(4*x0 + 3*x1 + 15*x3 <= 221)
m.addConstr(9*x1 + 12*x2 <= 55)
m.addConstr(14*x0 + 12*x3 <= 110)
m.addConstr(14*x0 + 9*x1 <= 63)
m.addConstr(2*x0 + 13*x1 <= 72)
m.addConstr(13*x1 + 8*x3 <= 62)
m.addConstr(2*x0 + 9*x2 <= 235)
m.addConstr(2*x0 + 9*x2 + 8*x3 <= 226)
m.addConstr(2*x0 + 13*x1 + 8*x3 <= 85)
m.addConstr(2*x0 + 13*x1 + 9*x2 <= 125)
m.addConstr(2*x2 + 16*x3 <= 206)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Ringo: ", x0.varValue)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Jean: ", x2.varValue)
    print("Hours worked by George: ", x3.varValue)
else:
    print("No solution found")
