
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="protein_bars")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="strips_of_bacon")
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="steaks")


    # Set objective function
    m.setObjective(6*x0 + 1*x1 + 8*x2 + 4*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5*x1 + 4*x2 + 6*x3 >= 21, "c1")
    m.addConstr(3*x0 + 4*x2 + 6*x3 >= 21, "c2")
    m.addConstr(3*x0 + 5*x1 + 6*x3 >= 21, "c3")
    m.addConstr(5*x1 + 4*x2 + 6*x3 >= 15, "c4")
    m.addConstr(3*x0 + 4*x2 + 6*x3 >= 15, "c5")
    m.addConstr(3*x0 + 5*x1 + 6*x3 >= 15, "c6")
    m.addConstr(5*x1 + 4*x2 + 6*x3 >= 19, "c7")
    m.addConstr(3*x0 + 4*x2 + 6*x3 >= 19, "c8")
    m.addConstr(3*x0 + 5*x1 + 6*x3 >= 19, "c9")
    m.addConstr(2*x0 - 10*x1 >= 0, "c10")
    m.addConstr(5*x1 + 6*x3 <= 97, "c11")
    m.addConstr(3*x0 + 6*x3 <= 47, "c12")
    m.addConstr(3*x0 + 4*x2 <= 89, "c13")
    m.addConstr(5*x1 + 4*x2 <= 98, "c14")
    m.addConstr(4*x2 + 6*x3 <= 30, "c15")
    m.addConstr(3*x0 + 5*x1 + 4*x2 + 6*x3 <= 98, "c16")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
