
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="corn_cobs", lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS)
x2 = m.addVar(name="protein_bars", lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS)
x3 = m.addVar(name="strips_of_bacon", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="steaks", lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(6*x1 + x2 + 8*x3 + 4*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 + 4*x3 + 6*x4 <= 98)
m.addConstr(5*x2 + 4*x3 + 6*x4 >= 21)
m.addConstr(3*x1 + 4*x3 + 6*x4 >= 21)
m.addConstr(5*x2 + 4*x3 + 6*x4 >= 15)
m.addConstr(3*x1 + 4*x3 + 6*x4 >= 15)
m.addConstr(3*x1 + 5*x2 + 6*x4 >= 15)
m.addConstr(5*x2 + 4*x3 + 6*x4 >= 19)
m.addConstr(3*x1 + 4*x3 + 6*x4 >= 19)
m.addConstr(3*x1 + 5*x2 + 6*x4 >= 19)
m.addConstr(2*x1 - 10*x2 >= 0)
m.addConstr(5*x2 + 6*x4 <= 97)
m.addConstr(3*x1 + 6*x4 <= 47)
m.addConstr(3*x1 + 4*x3 <= 89)
m.addConstr(5*x2 + 4*x3 <= 98)
m.addConstr(4*x3 + 6*x4 <= 30)
m.addConstr(3*x1 + 5*x2 + 4*x3 + 6*x4 <= 30)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Corn cobs: ", x1.varValue)
    print("Protein bars: ", x2.varValue)
    print("Strips of bacon: ", x3.varValue)
    print("Steaks: ", x4.varValue)
else:
    print("The model is infeasible")
