
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("muscle_growth")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B12
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B9
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # grams of fat
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin B5


    # Set objective function
    m.setObjective(4.44 * x0 + 1.36 * x1 + 2.79 * x2 + 9.58 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 1*x1 + 5*x2 + 16*x3 <= 426, "r0")
    m.addConstr(5*x2 + 16*x3 >= 97, "c1")
    m.addConstr(7*x0 + 16*x3 <= 339, "c2")
    m.addConstr(7*x0 + 1*x1 <= 182, "c3")
    m.addConstr(7*x0 + 5*x2 <= 168, "c4")
    m.addConstr(1*x1 + 5*x2 + 16*x3 <= 233, "c5")
    m.addConstr(7*x0 + 1*x1 + 5*x2 + 16*x3 <= 233, "c6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
