
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B12")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B9")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of fat")
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B5")
    
    # Set x1 = 1 as per given condition
    model.addConstr(x1 == 1, name="c1")
    
    # Constraints
    model.addConstr(5*x3 + 16*x4 >= 97, name="c2")
    model.addConstr(16*x4 <= 332, name="c3")
    model.addConstr(x2 <= 175, name="c4")
    model.addConstr(5*x3 <= 161, name="c5")
    model.addConstr(x2 + 5*x3 + 16*x4 <= 233, name="c6")
    model.addConstr(x2 + 5*x3 + 16*x4 <= 226, name="c7")
    
    # Objective function
    model.setObjective(4.44*x1 + 1.36*x2 + 2.79*x3 + 9.58*x4, gurobi.GRB.MAXIMIZE)
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Milligrams of vitamin B9: {x2.varValue}")
        print(f"Grams of fat: {x3.varValue}")
        print(f"Milligrams of vitamin B5: {x4.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
