
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize_Work_Hours")

    # Create variables
    mary = model.addVar(vtype=gp.GRB.INTEGER, name="mary")
    paul = model.addVar(vtype=gp.GRB.INTEGER, name="paul")
    john = model.addVar(vtype=gp.GRB.INTEGER, name="john")


    # Set objective function
    model.setObjective(4*mary + 7*paul + 3*john, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14*mary + 8*john >= 22, "c0")
    model.addConstr(14*mary + 3*paul >= 16, "c1")
    model.addConstr(14*mary + 3*paul + 8*john >= 16, "c2")
    model.addConstr(9*mary + 9*paul >= 14, "c3")
    model.addConstr(9*mary + 9*john >= 8, "c4")
    model.addConstr(9*paul + 9*john >= 21, "c5")
    model.addConstr(9*mary + 9*paul + 9*john >= 21, "c6")
    model.addConstr(5*mary - 8*john >= 0, "c7")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
