
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Paul
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by John

    # Define the objective function
    model.setObjective(4 * x0 + 7 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14 * x0 <= 142)
    model.addConstr(9 * x0 <= 67)
    model.addConstr(3 * x1 <= 142)
    model.addConstr(9 * x1 <= 67)
    model.addConstr(8 * x2 <= 142)
    model.addConstr(9 * x2 <= 67)
    model.addConstr(14 * x0 + 8 * x2 >= 22)
    model.addConstr(14 * x0 + 3 * x1 >= 16)
    model.addConstr(14 * x0 + 3 * x1 + 8 * x2 >= 16)
    model.addConstr(9 * x0 + 9 * x1 >= 14)
    model.addConstr(9 * x0 + 9 * x2 >= 8)
    model.addConstr(9 * x1 + 9 * x2 >= 21)
    model.addConstr(9 * x0 + 9 * x1 + 9 * x2 >= 21)
    model.addConstr(5 * x0 - 8 * x2 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {x0.varValue}")
        print(f"Hours worked by Paul: {x1.varValue}")
        print(f"Hours worked by John: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
