
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="oranges", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="kiwis", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="bananas", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(7.89*x0 + 1.44*x1 + 4.36*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x0 + 6*x1 >= 34)
m.addConstr(6*x1 + 6*x2 >= 17)
m.addConstr(6*x0 + 6*x2 >= 31)
m.addConstr(5*x0 - 10*x1 >= 0)
m.addConstr(6*x0 + 6*x2 <= 98)
m.addConstr(6*x0 + 6*x1 <= 62)
m.addConstr(6*x1 + 6*x2 <= 92)
m.addConstr(6*x0 + 6*x1 + 6*x2 <= 49)
m.addConstr(12*x1 + 8*x2 <= 90)
m.addConstr(9*x0 + 12*x1 <= 85)
m.addConstr(9*x0 + 12*x1 + 8*x2 <= 85)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oranges: ", x0.varValue)
    print("Kiwis: ", x1.varValue)
    print("Bananas: ", x2.varValue)
else:
    print("The model is infeasible")
