
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
hours = {}
workers = ['Jean', 'Peggy', 'Hank', 'Paul', 'John', 'George']
for i, worker in enumerate(workers):
    hours[worker] = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name=f"hours_{worker}")

# Set objective function
obj = 3.94 * hours['Jean'] + 2.48 * hours['Peggy'] + 4.93 * hours['Hank'] + 6.64 * hours['Paul'] + 1.7 * hours['John'] + 5.4 * hours['George']
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Set constraints based on the provided resources
computer_competence = {'Jean': 18, 'Peggy': 1, 'Hank': 26, 'Paul': 14, 'John': 10, 'George': 18}
likelihood_to_quit = {'Jean': 10, 'Peggy': 17, 'Hank': 15, 'Paul': 13, 'John': 17, 'George': 24}

# Example constraints (add all your constraints similarly)
m.addConstr(computer_competence['Paul'] * hours['Paul'] + computer_competence['John'] * hours['John'] >= 14)
m.addConstr(computer_competence['Hank'] * hours['Hank'] + computer_competence['George'] * hours['George'] >= 20)
# ... (add all other constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    for worker in workers:
        print(f'{worker}: {hours[worker].x}')
    print('Objective value:', m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

