
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Jean", lb=0)
x2 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x3 = m.addVar(name="hours_worked_by_Hank", lb=0)
x4 = m.addVar(name="hours_worked_by_Paul", lb=0)
x5 = m.addVar(name="hours_worked_by_John", lb=0)
x6 = m.addVar(name="hours_worked_by_George", lb=0)

# Objective function
m.setObjective(3.94*x1 + 2.48*x2 + 4.93*x3 + 6.64*x4 + 1.7*x5 + 5.4*x6, gp.GRB.MAXIMIZE)

# Constraints
# Jean's computer competence rating
m.addConstr(18*x1 <= 267)
m.addConstr(10*x1 <= 268)

# Peggy's computer competence rating
m.addConstr(1*x2 <= 267)
m.addConstr(17*x2 <= 268)

# Hank's computer competence rating
m.addConstr(26*x3 <= 267)
m.addConstr(15*x3 <= 268)

# Paul's computer competence rating
m.addConstr(14*x4 <= 267)
m.addConstr(13*x4 <= 268)

# John's computer competence rating
m.addConstr(10*x5 <= 267)
m.addConstr(17*x5 <= 268)

# George's computer competence rating
m.addConstr(18*x6 <= 267)
m.addConstr(24*x6 <= 268)

# Computer competence rating constraints
m.addConstr(14*x4 + 10*x5 >= 14)
m.addConstr(26*x3 + 18*x6 >= 20)
m.addConstr(1*x2 + 18*x6 >= 39)
m.addConstr(18*x1 + 10*x5 >= 18)
m.addConstr(18*x1 + 1*x2 + 10*x5 >= 32)
m.addConstr(26*x3 + 10*x5 + 18*x6 >= 32)
m.addConstr(1*x2 + 10*x5 + 18*x6 >= 32)
m.addConstr(1*x2 + 26*x3 + 10*x5 >= 32)
m.addConstr(18*x1 + 1*x2 + 10*x5 >= 34)
m.addConstr(26*x3 + 10*x5 + 18*x6 >= 34)
m.addConstr(1*x2 + 10*x5 + 18*x6 >= 34)
m.addConstr(1*x2 + 26*x3 + 10*x5 >= 34)
m.addConstr(18*x1 + 1*x2 + 10*x5 >= 40)
m.addConstr(26*x3 + 10*x5 + 18*x6 >= 40)
m.addConstr(1*x2 + 10*x5 + 18*x6 >= 40)
m.addConstr(1*x2 + 26*x3 + 10*x5 >= 40)

# Likelihood to quit index constraints
m.addConstr(10*x1 + 13*x4 >= 29)
m.addConstr(15*x3 + 17*x5 >= 38)
m.addConstr(10*x1 + 17*x5 >= 17)
m.addConstr(17*x2 + 15*x3 >= 16)
m.addConstr(15*x3 + 13*x4 >= 22)
m.addConstr(13*x4 + 24*x6 >= 44)
m.addConstr(17*x2 + 13*x4 >= 20)
m.addConstr(10*x1 + 24*x6 >= 35)
m.addConstr(17*x2 + 15*x3 + 13*x4 >= 43)
m.addConstr(17*x2 + 13*x4 + 17*x5 >= 43)
m.addConstr(10*x1 + 13*x4 + 17*x5 >= 43)
m.addConstr(10*x1 + 17*x2 + 15*x3 >= 43)
m.addConstr(15*x3 + 17*x5 + 24*x6 >= 43)
m.addConstr(15*x3 + 13*x4 + 24*x6 >= 43)
m.addConstr(17*x2 + 15*x3 + 24*x6 >= 43)
m.addConstr(17*x2 + 13*x4 + 24*x6 >= 43)
m.addConstr(10*x1 + 15*x3 + 17*x5 >= 43)
m.addConstr(17*x2 + 17*x5 + 24*x6 >= 43)
m.addConstr(10*x1 + 17*x2 + 13*x4 >= 43)
m.addConstr(10*x1 + 17*x2 + 24*x6 >= 43)

# Computer competence rating upper bound constraints
m.addConstr(14*x4 + 10*x5 <= 102)
m.addConstr(18*x1 + 18*x6 <= 223)
m.addConstr(1*x2 + 10*x5 <= 127)
m.addConstr(18*x1 + 14*x4 <= 263)
m.addConstr(18*x1 + 14*x4 + 18*x6 <= 192)
m.addConstr(1*x2 + 14*x4 + 18*x6 <= 154)
m.addConstr(1*x2 + 10*x5 + 18*x6 <= 187)
m.addConstr(18*x1 + 1*x2 + 14*x4 <= 266)
m.addConstr(1*x2 + 26*x3 + 14*x4 <= 142)
m.addConstr(18*x1 + 1*x2 + 10*x5 <= 249)
m.addConstr(18*x1 + 14*x4 + 10*x5 <= 184)
m.addConstr(1*x2 + 14*x4 + 10*x5 <= 170)
m.addConstr(1*x2 + 26*x3 + 10*x5 <= 207)
m.addConstr(26*x3 + 14*x4 + 10*x5 <= 138)

# Likelihood to quit index upper bound constraints
m.addConstr(15*x3 + 13*x4 <= 98)
m.addConstr(15*x3 + 24*x6 <= 209)
m.addConstr(17*x2 + 24*x6 <= 115)
m.addConstr(10*x1 + 15*x3 <= 196)
m.addConstr(17*x2 + 13*x4 <= 194)
m.addConstr(15*x3 + 17*x5 <= 113)
m.addConstr(13*x4 + 17*x5 <= 97)
m.addConstr(17*x2 + 15*x3 <= 77)
m.addConstr(17*x2 + 17*x5 <= 240)
m.addConstr(13*x4 + 24*x6 <= 235)
m.addConstr(17*x5 + 24*x6 <= 169)
m.addConstr(10*x1 + 17*x5 <= 53)
m.addConstr(17*x2 + 15*x3 + 17*x5 <= 152)
m.addConstr(15*x3 + 13*x4 + 17*x5 <= 256)
m.addConstr(15*x3 + 17*x5 + 24*x6 <= 267)
m.addConstr(10*x1 + 17*x5 + 24*x6 <= 216)
m.addConstr(13*x4 + 17*x5 + 24*x6 <= 132)
m.addConstr(10*x1 + 17*x2 + 15*x3 <= 78)
m.addConstr(10*x1 + 15*x3 + 13*x4 <= 72)
m.addConstr(10*x1 + 15*x3 + 24*x6 <= 233)
m.addConstr(10*x1 + 17*x2 + 17*x5 <= 69)
m.addConstr(10*x1 + 17*x2 + 24*x6 <= 167)
m.addConstr(10*x1 + 13*x4 + 17*x5 <= 147)
m.addConstr(17*x2 + 17*x5 + 24*x6 <= 183)
m.addConstr(10*x1 + 15*x3 + 17*x5 <= 215)
m.addConstr(10*x1 + 17*x2 + 15*x3 + 13*x4 + 17*x5 + 24*x6 <= 215)

# Solve the model
m.optimize()

# Print the solution
print("Objective: ", m.objVal)
print("Hours worked by Jean: ", x1.varValue)
print("Hours worked by Peggy: ", x2.varValue)
print("Hours worked by Hank: ", x3.varValue)
print("Hours worked by Paul: ", x4.varValue)
print("Hours worked by John: ", x5.varValue)
print("Hours worked by George: ", x6.varValue)
