
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")


    # Set objective function
    model.setObjective(5*x0 + 3*x1 + 4*x2 + 8*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(19*x2 + 11*x3 >= 24)
    model.addConstr(20*x0 + 23*x1 >= 22)
    model.addConstr(5*x0 - 2*x2 >= 0)
    model.addConstr(21*x0 + 13*x2 <= 97)
    model.addConstr(21*x0 + 29*x3 <= 101)
    model.addConstr(9*x1 + 13*x2 <= 126)
    model.addConstr(21*x0 + 9*x1 <= 179)
    model.addConstr(9*x1 + 29*x3 <= 106)
    model.addConstr(21*x0 + 9*x1 + 13*x2 + 29*x3 <= 106)
    model.addConstr(20*x0 + 19*x2 <= 101)
    model.addConstr(23*x1 + 11*x3 <= 98)
    model.addConstr(20*x0 + 11*x3 <= 111)
    model.addConstr(20*x0 + 23*x1 <= 219)
    model.addConstr(20*x0 + 23*x1 + 11*x3 <= 126)
    model.addConstr(20*x0 + 23*x1 + 19*x2 <= 123)
    model.addConstr(20*x0 + 19*x2 + 11*x3 <= 109)
    model.addConstr(20*x0 + 23*x1 + 19*x2 + 11*x3 <= 109)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
