
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', lb=0)  # hours worked by Dale
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Ringo
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Peggy
    x3 = model.addVar(name='x3', lb=0)  # hours worked by Hank

    # Define the objective function
    model.setObjective(5*x0 + 3*x1 + 4*x2 + 8*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(19*x2 + 11*x3 >= 24)
    model.addConstr(20*x0 + 23*x1 >= 22)
    model.addConstr(5*x0 - 2*x2 >= 0)
    model.addConstr(21*x0 + 13*x2 <= 97)
    model.addConstr(21*x0 + 29*x3 <= 101)
    model.addConstr(9*x1 + 13*x2 <= 126)
    model.addConstr(21*x0 + 9*x1 <= 179)
    model.addConstr(9*x1 + 29*x3 <= 106)
    model.addConstr(21*x0 + 9*x1 + 13*x2 + 29*x3 <= 266)
    model.addConstr(20*x0 + 19*x2 <= 101)
    model.addConstr(23*x1 + 11*x3 <= 98)
    model.addConstr(20*x0 + 11*x3 <= 111)
    model.addConstr(20*x0 + 23*x1 <= 219)
    model.addConstr(20*x0 + 23*x1 + 11*x3 <= 126)
    model.addConstr(20*x0 + 23*x1 + 19*x2 <= 123)
    model.addConstr(20*x0 + 19*x2 + 11*x3 <= 109)
    model.addConstr(20*x0 + 23*x1 + 19*x2 + 11*x3 <= 109)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Dale: ', x0.varValue)
        print('Hours worked by Ringo: ', x1.varValue)
        print('Hours worked by Peggy: ', x2.varValue)
        print('Hours worked by Hank: ', x3.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
