
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x0 = model.addVar(name="ravioli", lb=0)  # ravioli
x1 = model.addVar(name="knishes", lb=0)  # knishes
x2 = model.addVar(name="chicken_drumsticks", lb=0)  # chicken drumsticks

# Objective function
model.setObjective(6.2 * x0 + 1.9 * x1 + 6.3 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(0.37 * x0 + 0.97 * x2 >= 10)
model.addConstr(0.37 * x0 + 0.83 * x1 >= 3)
model.addConstr(0.37 * x0 + 0.83 * x1 + 0.97 * x2 >= 3)
model.addConstr(1.18 * x1 + 0.14 * x2 >= 14)
model.addConstr(0.39 * x0 + 0.14 * x2 >= 9)
model.addConstr(0.39 * x0 + 1.18 * x1 >= 8)
model.addConstr(0.39 * x0 + 1.18 * x1 + 0.14 * x2 >= 9)
model.addConstr(-2 * x0 + 6 * x1 >= 0)
model.addConstr(0.37 * x0 + 0.83 * x1 <= 21)
model.addConstr(0.39 * x0 + 0.14 * x2 <= 51)

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ravioli: {x0.varValue}")
    print(f"Knishes: {x1.varValue}")
    print(f"Chicken drumsticks: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
