
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of iron")
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="grams of fiber")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin A")


    # Set objective function
    m.setObjective(x0**2 + 3*x0*x1 + 4*x0*x2 + 9*x1*x2 + 7*x2**2 + 3*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(27*x0 + 14*x1 + x2 >= 58, "c1")
    m.addConstr(27*x0 + 14*x1 + x2 >= 62, "c2")
    m.addConstr(27*x0**2 + x2**2 <= 177, "c3")
    m.addConstr(27*x0 + 14*x1 + x2 <= 177, "c4")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('milligrams of iron:', x0.x)
        print('grams of fiber:', x1.x)
        print('milligrams of vitamin A:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

