
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="milligrams_of_iron")
x2 = m.addVar(vtype=GRB.INTEGER, lb=0, name="grams_of_fiber")  # Ensure x2 is an integer
x3 = m.addVar(lb=0, name="milligrams_of_vitamin_A")

# Objective function: Maximize
m.setObjective(1*x1**2 + 3*x1*x2 + 4*x1*x3 + 9*x2*x3 + 7*x3**2 + 3*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 == 27, "iron_constraint")
m.addConstr(27 + x3 >= 58, "iron_vitaminA_min")
m.addConstr(41 + x3 >= 62, "all_min")  # Simplified from 27 + 14 + x3 >= 62
m.addConstr(x1**2 + x3**2 <= 177, "squared_max")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of iron: {x1.x}")
    print(f"Grams of fiber: {x2.x}")
    print(f"Milligrams of vitamin A: {x3.x}")
else:
    print("No optimal solution found.")
