
import gurobi as gp
from gurobi import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="milligrams_of_iron")  
x2 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="grams_of_fiber", vtype=GRB.INTEGER)  
x3 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="milligrams_of_vitamin_A")  

# Objective function
m.setObjective(1*x1**2 + 3*x1*x2 + 4*x1*x3 + 9*x2*x3 + 7*x3**2 + 3*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(27*x1 <= 234, name="cognitive_performance_index_iron")
m.addConstr(14*x2 <= 234, name="cognitive_performance_index_fiber")
m.addConstr(x3 <= 234, name="cognitive_performance_index_vitamin_A")
m.addConstr(27*x1 + x3 >= 58, name="combined_cognitive_performance_index_iron_vitamin_A")
m.addConstr(27*x1 + 14*x2 + x3 >= 62, name="combined_cognitive_performance_index_all")
m.addConstr((27*x1)**2 + x3**2 <= 177, name="combined_cognitive_performance_index_squared")
m.addConstr(27*x1 + 14*x2 + x3 <= 177, name="combined_cognitive_performance_index_all_leq")

# Solve the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of iron: {x1.varValue}")
    print(f"Grams of fiber: {x2.varValue}")
    print(f"Milligrams of vitamin A: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
