
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
ibuprofen = m.addVar(vtype=gp.GRB.INTEGER, name="ibuprofen")
toilet_paper = m.addVar(vtype=gp.GRB.INTEGER, name="toilet_paper")
cookies = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")
lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")

# Set objective function
m.setObjective(8*ibuprofen + 2*toilet_paper + 9*cookies + 1*lightbulbs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*ibuprofen + 7*cookies >= 36)
m.addConstr(8*ibuprofen + 7*lightbulbs >= 47)
m.addConstr(8*ibuprofen + 14*toilet_paper + 7*lightbulbs >= 29)
m.addConstr(14*toilet_paper + 7*cookies + 7*lightbulbs >= 29)
m.addConstr(8*ibuprofen + 14*toilet_paper + 7*lightbulbs >= 35)
m.addConstr(14*toilet_paper + 7*cookies + 7*lightbulbs >= 35)
m.addConstr(8*ibuprofen + 14*toilet_paper + 7*cookies + 7*lightbulbs >= 35)
m.addConstr(8*cookies + 6*lightbulbs >= 43)
m.addConstr(10*ibuprofen + 8*cookies >= 31)
m.addConstr(10*ibuprofen + 13*toilet_paper >= 19)
m.addConstr(13*toilet_paper + 8*cookies + 6*lightbulbs >= 38)
m.addConstr(10*ibuprofen + 13*toilet_paper + 6*lightbulbs >= 38)
m.addConstr(13*toilet_paper + 8*cookies + 6*lightbulbs >= 29)
m.addConstr(10*ibuprofen + 13*toilet_paper + 6*lightbulbs >= 29)
m.addConstr(10*ibuprofen + 13*toilet_paper + 8*cookies + 6*lightbulbs >= 29)
m.addConstr(5*toilet_paper - 2*lightbulbs >= 0)
m.addConstr(8*cookies + 6*lightbulbs <= 74)
m.addConstr(10*ibuprofen + 13*toilet_paper + 6*lightbulbs <= 77)
m.addConstr(10*ibuprofen + 8*cookies + 6*lightbulbs <= 96)
m.addConstr(8*ibuprofen + 14*toilet_paper <= 208)
m.addConstr(10*ibuprofen + 13*toilet_paper + 8*cookies + 6*lightbulbs <= 182)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

