
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # bottles of ibuprofen
x1 = m.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # toilet paper rolls
x2 = m.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # cookies
x3 = m.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # lightbulbs

# Define the objective function
m.setObjective(8*x0 + 2*x1 + 9*x2 + x3, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x0 >= 8)
m.addConstr(10*x0 <= 182)
m.addConstr(14*x1 <= 208)
m.addConstr(13*x1 <= 182)
m.addConstr(7*x2 <= 208)
m.addConstr(8*x2 <= 182)
m.addConstr(7*x3 <= 208)
m.addConstr(6*x3 <= 182)
m.addConstr(8*x0 + 7*x2 >= 36)
m.addConstr(8*x0 + 7*x3 >= 47)
m.addConstr(8*x0 + 14*x1 + 7*x3 >= 29)
m.addConstr(14*x1 + 7*x2 + 7*x3 >= 29)
m.addConstr(8*x0 + 14*x1 + 7*x3 >= 35)
m.addConstr(14*x1 + 7*x2 + 7*x3 >= 35)
m.addConstr(8*x0 + 14*x1 + 7*x2 + 7*x3 >= 35)
m.addConstr(8*x2 + 6*x3 >= 43)
m.addConstr(10*x0 + 8*x2 >= 31)
m.addConstr(10*x0 + 13*x1 >= 19)
m.addConstr(13*x1 + 8*x2 + 6*x3 >= 38)
m.addConstr(10*x0 + 13*x1 + 6*x3 >= 38)
m.addConstr(13*x1 + 8*x2 + 6*x3 >= 29)
m.addConstr(10*x0 + 13*x1 + 6*x3 >= 29)
m.addConstr(10*x0 + 13*x1 + 8*x2 + 6*x3 >= 29)
m.addConstr(5*x1 - 2*x3 >= 0)
m.addConstr(8*x2 + 6*x3 <= 74)
m.addConstr(10*x0 + 13*x1 + 6*x3 <= 77)
m.addConstr(10*x0 + 8*x2 + 6*x3 <= 96)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('No optimal solution found')
