
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B12
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # milligrams of magnesium
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin E
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # milligrams of vitamin B5


# Set objective function
m.setObjective(2*x0 + 6*x1 + 4*x2 + 4*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 8*x2 + 1*x3 >= 25)
m.addConstr(3*x2 + 6*x3 >= 10)
m.addConstr(4*x0 + 5*x1 >= 11)
m.addConstr(4*x0 + 10*x2 >= 22)
m.addConstr(10*x2 + 4*x3 >= 25)
m.addConstr(4*x0 + 4*x3 >= 9)
m.addConstr(4*x0 + 10*x2 + 4*x3 >= 22)
m.addConstr(2*x0 - 6*x2 >= 0)
m.addConstr(3*x1 + 8*x2 <= 104)
m.addConstr(3*x1 + 8*x2 + 1*x3 <= 107)
m.addConstr(6*x0 + 8*x2 + 1*x3 <= 50)
m.addConstr(6*x0 + 3*x1 + 1*x3 <= 104)
m.addConstr(6*x0 + 3*x1 + 8*x2 <= 71)
m.addConstr(6*x0 + 3*x1 + 8*x2 + 1*x3 <= 71)
m.addConstr(1*x0 + 8*x1 <= 104)
m.addConstr(1*x0 + 6*x3 <= 80)
m.addConstr(8*x1 + 6*x3 <= 35)
m.addConstr(1*x0 + 3*x2 <= 86)
m.addConstr(8*x1 + 3*x2 <= 57)
m.addConstr(1*x0 + 8*x1 + 6*x3 <= 51)
m.addConstr(1*x0 + 8*x1 + 3*x2 + 6*x3 <= 51)
m.addConstr(8*x0 + 9*x3 <= 69)
m.addConstr(4*x1 + 8*x2 <= 67)
m.addConstr(8*x2 + 9*x3 <= 35)
m.addConstr(8*x0 + 4*x1 <= 60)
m.addConstr(8*x0 + 4*x1 + 8*x2 <= 82)
m.addConstr(8*x0 + 4*x1 + 8*x2 + 9*x3 <= 82)
m.addConstr(4*x0 + 4*x3 <= 39)
m.addConstr(4*x0 + 5*x1 + 10*x2 + 4*x3 <= 39)

# Resource constraints
m.addConstr(6*x0 + 3*x1 + 8*x2 + x3 <= 110)
m.addConstr(x0 + 8*x1 + 3*x2 + 6*x3 <= 110)
m.addConstr(8*x0 + 4*x1 + 8*x2 + 9*x3 <= 88)
m.addConstr(4*x0 + 5*x1 + 10*x2 + 4*x3 <= 103)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

