
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x0")  # milligrams of vitamin B12
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # milligrams of magnesium
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # milligrams of vitamin E
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B5

    # Objective function
    model.setObjective(2 * x0 + 6 * x1 + 4 * x2 + 4 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * x0 <= 110)
    model.addConstr(x0 <= 110)
    model.addConstr(8 * x0 <= 88)
    model.addConstr(4 * x0 <= 103)
    model.addConstr(3 * x1 <= 110)
    model.addConstr(8 * x1 <= 110)
    model.addConstr(4 * x1 <= 88)
    model.addConstr(5 * x1 <= 103)
    model.addConstr(8 * x2 <= 110)
    model.addConstr(3 * x2 <= 110)
    model.addConstr(8 * x2 <= 88)
    model.addConstr(10 * x2 <= 103)
    model.addConstr(x3 <= 110)
    model.addConstr(6 * x3 <= 110)
    model.addConstr(9 * x3 <= 88)
    model.addConstr(4 * x3 <= 103)
    model.addConstr(3 * x1 + 8 * x2 + x3 >= 25)
    model.addConstr(3 * x2 + 6 * x3 >= 10)
    model.addConstr(4 * x0 + 5 * x1 >= 11)
    model.addConstr(4 * x0 + 10 * x2 >= 22)
    model.addConstr(10 * x2 + 4 * x3 >= 25)
    model.addConstr(4 * x0 + 4 * x3 >= 9)
    model.addConstr(4 * x0 + 10 * x2 + 4 * x3 >= 22)
    model.addConstr(2 * x0 - 6 * x2 >= 0)
    model.addConstr(3 * x1 + 8 * x2 <= 104)
    model.addConstr(3 * x1 + 8 * x2 + x3 <= 107)
    model.addConstr(6 * x0 + 8 * x2 + x3 <= 50)
    model.addConstr(6 * x0 + 3 * x1 + x3 <= 104)
    model.addConstr(6 * x0 + 3 * x1 + 8 * x2 <= 71)
    model.addConstr(6 * x0 + 3 * x1 + 8 * x2 + x3 <= 71)
    model.addConstr(x0 + 8 * x1 <= 104)
    model.addConstr(x0 + 6 * x3 <= 80)
    model.addConstr(8 * x1 + 6 * x3 <= 35)
    model.addConstr(x0 + 3 * x2 <= 86)
    model.addConstr(8 * x1 + 3 * x2 <= 57)
    model.addConstr(x0 + 8 * x1 + 6 * x3 <= 51)
    model.addConstr(x0 + 8 * x1 + 3 * x2 + 6 * x3 <= 51)
    model.addConstr(8 * x0 + 9 * x3 <= 69)
    model.addConstr(4 * x1 + 8 * x2 <= 67)
    model.addConstr(8 * x2 + 9 * x3 <= 35)
    model.addConstr(8 * x0 + 4 * x1 <= 60)
    model.addConstr(8 * x0 + 4 * x1 + 8 * x2 <= 82)
    model.addConstr(8 * x0 + 4 * x1 + 8 * x2 + 9 * x3 <= 82)
    model.addConstr(4 * x0 + 4 * x3 <= 39)
    model.addConstr(4 * x0 + 5 * x1 + 10 * x2 + 4 * x3 <= 39)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"milligrams of vitamin B12: {x0.varValue}")
        print(f"milligrams of magnesium: {x1.varValue}")
        print(f"milligrams of vitamin E: {x2.varValue}")
        print(f"milligrams of vitamin B5: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
