
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Peggy
    x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1") # hours worked by Bobby


    # Set objective function
    model.setObjective(2*x0 + 7*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4*x0 + 14*x1 >= 65, "c0")
    model.addConstr(15*x0 + 24*x1 >= 22, "c1")
    model.addConstr(19*x0 + 2*x1 >= 72, "c2")
    model.addConstr(-4*x0 + 6*x1 >= 0, "c3")
    model.addConstr(4*x0 + 14*x1 <= 119, "c4")
    model.addConstr(15*x0 + 24*x1 <= 59, "c5")
    model.addConstr(19*x0 + 2*x1 <= 199, "c6")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        print("x0 (hours worked by Peggy):", x0.x)
        print("x1 (hours worked by Bobby):", x1.x)

except gp.GurobiError as e:
    print("Error code " + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
