
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Peggy", lb=0)  
x1 = m.addVar(name="hours_worked_by_Bobby", lb=0, type=gp.GRB.INTEGER)  

# Define the objective function
m.setObjective(2 * x0 + 7 * x1, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * x0 + 14 * x1 >= 65, name="organization_score_min")
m.addConstr(15 * x0 + 24 * x1 >= 22, name="work_quality_rating_min")
m.addConstr(19 * x0 + 2 * x1 >= 72, name="paperwork_competence_rating_min")
m.addConstr(-4 * x0 + 6 * x1 >= 0, name="linear_constraint")
m.addConstr(4 * x0 + 14 * x1 <= 119, name="organization_score_max")
m.addConstr(15 * x0 + 24 * x1 <= 59, name="work_quality_rating_max")
m.addConstr(19 * x0 + 2 * x1 <= 199, name="paperwork_competence_rating_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Peggy: {x0.varValue}")
    print(f"Hours worked by Bobby: {x1.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
