
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
mary_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")
ringo_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo_hours")


# Set objective function
m.setObjective(1 * laura_hours + 2 * dale_hours + 9 * mary_hours + 1 * ringo_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.13 * laura_hours + 5.7 * dale_hours >= 43)
m.addConstr(3.13 * laura_hours + 5.7 * dale_hours + 7.03 * ringo_hours >= 28)
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours >= 60)
m.addConstr(7.47 * dale_hours + 5.15 * ringo_hours >= 77)
m.addConstr(4.0 * mary_hours + 7.03 * ringo_hours <= 166)
m.addConstr(3.13 * laura_hours + 5.7 * dale_hours <= 98)
m.addConstr(5.7 * dale_hours + 7.03 * ringo_hours <= 115)
m.addConstr(3.13 * laura_hours + 7.03 * ringo_hours <= 190)
m.addConstr(5.7 * dale_hours + 4.0 * mary_hours <= 116)
m.addConstr(5.7 * dale_hours + 4.0 * mary_hours + 7.03 * ringo_hours <= 143)
m.addConstr(3.13 * laura_hours + 4.0 * mary_hours + 7.03 * ringo_hours <= 67)
m.addConstr(3.13 * laura_hours + 5.7 * dale_hours + 4.0 * mary_hours + 7.03 * ringo_hours <= 67)
m.addConstr(5.79 * laura_hours + 4.21 * dale_hours <= 144)
m.addConstr(9.35 * mary_hours + 5.22 * ringo_hours <= 120)
m.addConstr(5.79 * laura_hours + 5.22 * ringo_hours <= 198)
m.addConstr(5.79 * laura_hours + 9.35 * mary_hours + 5.22 * ringo_hours <= 85)
m.addConstr(5.79 * laura_hours + 4.21 * dale_hours + 9.35 * mary_hours <= 146)
m.addConstr(4.21 * dale_hours + 9.35 * mary_hours + 5.22 * ringo_hours <= 59)
m.addConstr(5.79 * laura_hours + 4.21 * dale_hours + 9.35 * mary_hours + 5.22 * ringo_hours <= 59)
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours <= 84)
m.addConstr(1.57 * mary_hours + 5.15 * ringo_hours <= 115)
m.addConstr(8.68 * laura_hours + 5.15 * ringo_hours <= 213)
m.addConstr(7.47 * dale_hours + 1.57 * mary_hours <= 114)
m.addConstr(7.47 * dale_hours + 5.15 * ringo_hours <= 311)
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours + 1.57 * mary_hours <= 229)
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours + 5.15 * ringo_hours <= 221)
m.addConstr(8.68 * laura_hours + 1.57 * mary_hours + 5.15 * ringo_hours <= 243)
m.addConstr(8.68 * laura_hours + 7.47 * dale_hours + 1.57 * mary_hours + 5.15 * ringo_hours <= 243)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

