
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Laura", lb=0)
x1 = m.addVar(name="hours_worked_by_Dale", lb=0)
x2 = m.addVar(name="hours_worked_by_Mary", lb=0)
x3 = m.addVar(name="hours_worked_by_Ringo", lb=0)

# Define the objective function
m.setObjective(x0 + 2*x1 + 9*x2 + x3, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(3.13*x0 + 5.7*x1 >= 43)
m.addConstr(3.13*x0 + 5.7*x1 + 4.0*x2 + 7.03*x3 >= 28)
m.addConstr(8.68*x0 + 7.47*x1 >= 60)
m.addConstr(7.47*x1 + 5.15*x3 >= 77)
m.addConstr(4.0*x2 + 7.03*x3 <= 166)
m.addConstr(3.13*x0 + 5.7*x1 <= 98)
m.addConstr(5.7*x1 + 7.03*x3 <= 115)
m.addConstr(3.13*x0 + 7.03*x3 <= 190)
m.addConstr(5.7*x1 + 4.0*x2 <= 116)
m.addConstr(5.7*x1 + 4.0*x2 + 7.03*x3 <= 143)
m.addConstr(3.13*x0 + 4.0*x2 + 7.03*x3 <= 67)
m.addConstr(3.13*x0 + 5.7*x1 + 4.0*x2 + 7.03*x3 <= 67)
m.addConstr(5.79*x0 + 4.21*x1 <= 144)
m.addConstr(9.35*x2 + 5.22*x3 <= 120)
m.addConstr(5.79*x0 + 5.22*x3 <= 198)
m.addConstr(5.79*x0 + 9.35*x2 + 5.22*x3 <= 85)
m.addConstr(5.79*x0 + 4.21*x1 + 9.35*x2 <= 146)
m.addConstr(4.21*x1 + 9.35*x2 + 5.22*x3 <= 59)
m.addConstr(5.79*x0 + 4.21*x1 + 9.35*x2 + 5.22*x3 <= 59)
m.addConstr(8.68*x0 + 7.47*x1 <= 84)
m.addConstr(1.57*x2 + 5.15*x3 <= 115)
m.addConstr(8.68*x0 + 5.15*x3 <= 213)
m.addConstr(7.47*x1 + 1.57*x2 <= 114)
m.addConstr(7.47*x1 + 5.15*x3 <= 311)
m.addConstr(8.68*x0 + 7.47*x1 + 1.57*x2 <= 229)
m.addConstr(8.68*x0 + 7.47*x1 + 5.15*x3 <= 221)
m.addConstr(8.68*x0 + 1.57*x2 + 5.15*x3 <= 243)
m.addConstr(8.68*x0 + 7.47*x1 + 1.57*x2 + 5.15*x3 <= 243)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Laura: ", x0.varValue)
    print("Hours worked by Dale: ", x1.varValue)
    print("Hours worked by Mary: ", x2.varValue)
    print("Hours worked by Ringo: ", x3.varValue)
else:
    print("The model is infeasible")
