
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="postage_stamps")
x2 = m.addVar(vtype=GRB.INTEGER, name="paper_clips")
x3 = m.addVar(vtype=GRB.INTEGER, name="headsets")

# Set the objective function
m.setObjective(7.71*x1 + 6.19*x2 + 5.07*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(4.49*x1 + 1.38*x3 >= 50, name="constraint_1")
m.addConstr(3.37*x2 + 1.38*x3 >= 38, name="constraint_2")
m.addConstr(4.49*x1 + 3.37*x2 + 1.38*x3 >= 67, name="constraint_3")
m.addConstr(6*x1 - 6*x2 >= 0, name="constraint_4")
m.addConstr(4*x1 - 5*x3 >= 0, name="constraint_5")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Postage Stamps: {x1.x}")
    print(f"Paper Clips: {x2.x}")
    print(f"Headsets: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
