
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="postage_stamps", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="paper_clips", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="headsets", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7.71*x1 + 6.19*x2 + 5.07*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4.49*x1 <= 233)
    model.addConstr(3.37*x2 <= 233)
    model.addConstr(1.38*x3 <= 233)
    model.addConstr(4.49*x1 + 1.38*x3 >= 50)
    model.addConstr(3.37*x2 + 1.38*x3 >= 38)
    model.addConstr(4.49*x1 + 3.37*x2 + 1.38*x3 >= 67)
    model.addConstr(6*x1 - 6*x2 >= 0)
    model.addConstr(4*x1 - 5*x3 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Postage stamps: {x1.varValue}")
        print(f"Paper clips: {x2.varValue}")
        print(f"Headsets: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
