
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    protein_bars = m.addVar(vtype=GRB.INTEGER, name="protein_bars")
    strawberries = m.addVar(vtype=GRB.CONTINUOUS, name="strawberries")

    # Set objective function
    m.setObjective(9*protein_bars**2 + 9*protein_bars*strawberries, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*protein_bars**2 + 14*strawberries**2 >= 24, "tastiness_rating_constraint")
    m.addConstr(8*protein_bars**2 + 12*strawberries**2 >= 12, "protein_constraint")
    m.addConstr(3*protein_bars + 5*strawberries >= 32, "umami_index_constraint")
    m.addConstr(7*protein_bars - 10*strawberries >= 0, "constraint4")
    m.addConstr(13*protein_bars + 14*strawberries <= 41, "constraint5")
    m.addConstr(8*protein_bars + 12*strawberries <= 36, "constraint6")
    m.addConstr(3*protein_bars**2 + 5*strawberries**2 <= 40, "constraint7")
    m.addConstr(3*protein_bars + 5*strawberries <= 40, "constraint8")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('protein_bars:', protein_bars.x)
        print('strawberries:', strawberries.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
