
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="protein_bars", vtype=gp.GRB.INTEGER)  # integer number of protein bars
x2 = m.addVar(name="strawberries")  # any number of strawberries

# Define the objective function
m.setObjective(9 * x1**2 + 9 * x1 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(13**2 * x1**2 + 14**2 * x2**2 >= 24, name="tastiness_rating")
m.addConstr(8**2 * x1**2 + 12**2 * x2**2 >= 12, name="grams_of_protein")
m.addConstr(3 * x1 + 5 * x2 >= 32, name="umami_index_min")
m.addConstr(7 * x1 - 10 * x2 >= 0, name="protein_bars_vs_strawberries")
m.addConstr(13 * x1 + 14 * x2 <= 41, name="total_tastiness_rating")
m.addConstr(8 * x1 + 12 * x2 <= 36, name="total_grams_of_protein")
m.addConstr(3**2 * x1**2 + 5**2 * x2**2 <= 40, name="total_umami_index_squared")
m.addConstr(3 * x1 + 5 * x2 <= 40, name="total_umami_index")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Protein bars: {x1.varValue}")
    print(f"Strawberries: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
