
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Dale")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Hank")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Bill")


# Set objective function
m.setObjective(1*x0 + 5*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*x0 + 3*x1 >= 6)
m.addConstr(9*x0 + 3*x1 + 11*x2 >= 12)
m.addConstr(5*x1 + 5*x2 >= 19)
m.addConstr(10*x0 + 5*x1 >= 17)
m.addConstr(10*x0 + 5*x1 + 5*x2 >= 26)
m.addConstr(4*x0 + 5*x1 + 8*x2 >= 27)
m.addConstr(14*x0 + 12*x2 >= 5)
m.addConstr(14*x0 + 9*x1 >= 9)
m.addConstr(9*x0 + 13*x2 >= 8)
m.addConstr(9*x0 + 1*x1 >= 6)
m.addConstr(3*x1 + 11*x2 <= 41)
m.addConstr(9*x0 + 3*x1 <= 47)
m.addConstr(9*x0 + 3*x1 + 11*x2 <= 38)
m.addConstr(10*x0 + 5*x2 <= 37)
m.addConstr(10*x0 + 5*x1 <= 57)
m.addConstr(10*x0 + 5*x1 + 5*x2 <= 57)
m.addConstr(5*x1 + 8*x2 <= 103)
m.addConstr(4*x0 + 5*x1 <= 78)
m.addConstr(4*x0 + 5*x1 + 8*x2 <= 78)
m.addConstr(14*x0 + 9*x1 <= 21)
m.addConstr(14*x0 + 12*x2 <= 22)
m.addConstr(14*x0 + 9*x1 + 12*x2 <= 22)
m.addConstr(9*x0 + 13*x2 <= 43)
m.addConstr(9*x0 + 1*x1 + 13*x2 <= 43)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

