
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER)  # hours worked by Dale
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # hours worked by Hank
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # hours worked by Bill

# Define the objective function
m.setObjective(x0 + 5 * x1 + 5 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * x0 >= 9)
m.addConstr(10 * x0 >= 10)
m.addConstr(4 * x0 >= 4)
m.addConstr(14 * x0 >= 14)
m.addConstr(9 * x0 >= 9)

m.addConstr(3 * x1 >= 3)
m.addConstr(5 * x1 >= 5)
m.addConstr(5 * x1 >= 5)
m.addConstr(9 * x1 >= 9)
m.addConstr(1 * x1 >= 1)

m.addConstr(11 * x2 >= 11)
m.addConstr(5 * x2 >= 5)
m.addConstr(8 * x2 >= 8)
m.addConstr(12 * x2 >= 12)
m.addConstr(13 * x2 >= 13)

m.addConstr(9 * x0 + 3 * x1 >= 6)
m.addConstr(9 * x0 + 3 * x1 + 11 * x2 >= 12)
m.addConstr(5 * x1 + 5 * x2 >= 19)
m.addConstr(10 * x0 + 5 * x1 >= 17)
m.addConstr(10 * x0 + 5 * x1 + 5 * x2 >= 26)
m.addConstr(4 * x0 + 5 * x1 + 8 * x2 >= 27)
m.addConstr(14 * x0 + 12 * x2 >= 5)
m.addConstr(14 * x0 + 9 * x1 >= 9)
m.addConstr(9 * x0 + 13 * x2 >= 8)
m.addConstr(9 * x0 + 1 * x1 >= 6)

m.addConstr(3 * x1 + 11 * x2 <= 41)
m.addConstr(9 * x0 + 3 * x1 <= 47)
m.addConstr(9 * x0 + 3 * x1 + 11 * x2 <= 38)
m.addConstr(10 * x0 + 5 * x2 <= 37)
m.addConstr(10 * x0 + 5 * x1 <= 57)
m.addConstr(10 * x0 + 5 * x1 + 5 * x2 <= 57)
m.addConstr(5 * x1 + 8 * x2 <= 103)
m.addConstr(4 * x0 + 5 * x1 <= 78)
m.addConstr(4 * x0 + 5 * x1 + 8 * x2 <= 78)
m.addConstr(14 * x0 + 9 * x1 <= 21)
m.addConstr(14 * x0 + 12 * x2 <= 22)
m.addConstr(14 * x0 + 9 * x1 + 12 * x2 <= 22)
m.addConstr(9 * x0 + 13 * x2 <= 43)
m.addConstr(9 * x0 + 1 * x1 + 13 * x2 <= 43)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Dale: ", x0.varValue)
    print("Hours worked by Hank: ", x1.varValue)
    print("Hours worked by Bill: ", x2.varValue)
else:
    print("The model is infeasible")
